/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp;

import com.gprinter.udp.Response;
import com.gprinter.utils.ConvertUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class UdpCommand {
    private long uuid;
    private ResponseListener responseListener;
    private int responseTimeout = 500;

    public abstract byte[] getCommand();

    public Response resolveResponseData(long uuid, byte[] data) {
        return null;
    }

    public ResponseListener getResponseListener() {
        return this.responseListener;
    }

    public void setResponseListener(ResponseListener responseListener) {
        this.responseListener = responseListener;
    }

    public byte[] toBytes(Vector<Byte> src) {
        if (src == null || src.size() < 1) {
            return new byte[0];
        }
        byte[] dst = new byte[src.size()];
        for (int i = 0; i < src.size(); ++i) {
            dst[i] = src.get(i);
        }
        return dst;
    }

    public String toString() {
        return ConvertUtils.bytesToHex(this.getCommand());
    }

    protected Map<String, String> getResponseMap(byte[] data) {
        String[] split;
        if (data == null || data.length < 1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String dat = new String(data);
        for (String s : split = dat.split(";")) {
            String[] sub;
            if (s.isEmpty() || (sub = s.split(":")).length < 2) continue;
            map.put(sub[0], sub[1]);
        }
        return map;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public static interface ResponseListener<K extends Response> {
        public void onResponse(UdpCommand var1, K var2);
    }
}

